#include "c4d_basekey.h"
#include "c4d_basesequence.h"
#include "c4d_basetrack.h"
#include "c4d_baseobject.h"

Bool BaseTrack::InsertSequence(BaseSequence *bs, Bool check)
{
	return C4DOS.Be->InsertSequence(this,bs,check);
}

Bool BaseTrack::AnimateObject(BaseDocument *doc, BaseList2D *op, const BaseTime &time, LONG flags, void *data)
{
	return C4DOS.Be->AnimateObject(this,doc,op,time,flags,data);
}

BaseSequence *BaseTrack::AutoAddSequence(BaseDocument *doc, const BaseTime &time)
{
	return C4DOS.Be->AutoAddSequence(this,doc,time);
}

BaseSequence *BaseTrack::FindSequence(const BaseTime &time)
{
	return C4DOS.Be->FindSequence(this,time);
}

BaseSequence *BaseTrack::GetFirstSequence(void)
{
	return C4DOS.Be->GetFirstSequence(this);
}

const DescID &BaseTrack::GetDescriptionID(void)
{
	return C4DOS.Be->GetDescriptionID(this);
}

BaseTrack *BaseTrack::Alloc(LONG type)
{
	return C4DOS.Be->Alloc(type,0);
}

void BaseTrack::Free(BaseTrack *&bl)
{
	C4DOS.Bl->Free(bl);
	bl=NULL;
}

PluginTrack *PluginTrack::Alloc(LONG type)
{
	return (PluginTrack*)C4DOS.Be->Alloc(type,0);
}

void PluginTrack::Free(PluginTrack *&bl)
{
	C4DOS.Bl->Free(bl);
	bl=NULL;
}


BaseTrack *AllocValueTrack(Atom *op, const DescID &id)
{
	return C4DOS.Be->AllocValueTrack(op,id);
}

BaseTrack *AllocDataTrack(Atom *op, const DescID &id)
{
	return C4DOS.Be->AllocDataTrack(op,id);
}

BaseTrack *AllocTimeTrack()
{
	return C4DOS.Be->AllocTimeTrack();
}
